// FILELINE.CPP
//
// Copyright (c) 1997-1999 Symbian Ltd.  All rights reserved.
//

#include <assert.h>
#include <string.h>
#include <stdlib.h>
#include <sys/param.h> // PATH_MAX
#include "astring.h"
#include "fileline.h"
#include "numval.h"
#include "tokens.h"

FileLineManager::FileLineManager():
	iOffsetLineNumber(0)
	{}

FileLineManager::~FileLineManager()
	{}

void FileLineManager::SetBase(const String& aFileName,int aLineNumber)
	{
	iBaseFileName=aFileName;
	iCurrentFileName=aFileName;
	iOffsetLineNumber=aLineNumber;
	}

void FileLineManager::SetPath(const String& aDriveAndDirectory)
	{
	iBasePath=aDriveAndDirectory;
	}

String FileLineManager::ExtractFileName( const String & Text)
	{

    // The string that is passed to this procedure is expected to contain
    // a file specification followed by a " followed by other stuff that
    // is generated by the preprocessor.  We can discard the latter stuff.
    // This will leave either an empty string (implying the base file name)
    // or a unix-format relative file specification.

    // This string class has very little functionality, so we end up
    // doing traditional C-style stuff on a char buffer to achieve
    // what we need  {sigh}...

    char buffer[PATH_MAX + 1];
    // (older version of this code used heap allocation but I prefer
    //  this way which is safer and does less heap-churning)

    
    String result;      // This is what we will pass back

	// Copy the text to our working buffer

    int n = Text.Length();
    if ( n >= PATH_MAX ) n = PATH_MAX; // Unlikely, but you never know
    strncpy(buffer, Text.GetBuffer(), n);
    buffer[n] = '\0';                  // add zero terminator

    // truncate to the expected double quote character

    char * pquote = strchr(buffer, '"');
    if ( pquote != NULL ) * pquote = '\0';

    n = strlen(buffer);


    // If we now have an empty string then replace it with the
    // base filename string that should already be defined.

    if ( n == 0 )
        {
        n = iBaseFileName.Length();
        if ( n > PATH_MAX ) n = PATH_MAX;
        if (n>0) strncpy(buffer, iBaseFileName.GetBuffer(), n);
        buffer[n] = '\0';
        }

    // Replace all the unix-like forward slashes with DOS-like backslashes
    while ( n > 0 )
        {
        n -=1;
        if ( buffer[n] == '/' ) {
		buffer[n] = '\\';
	}
        }
    
    
    result = buffer;
    return result;
    
    
    
    // This stuff bombs (illegal address) and I've commented it out
    // because its purpose is unclear in any case.
	
//	if ( strlen(pBuf) == 0)
//		{
//		delete pBuf;
//		pBuf = new char[iBaseFileName.Length()+1];
//		strcpy(pBuf,iBaseFileName.GetBuffer());
//		}
//
//	String	s;
//
//	// Add on base path.
//	if ( pBuf[1] == ':' || pBuf[0] == '\\')
//		s = pBuf;
//	else
//		s = iBasePath + "\\" + pBuf;
//
//	// Replace '\\' with '\' and replace '/' with '\'.
//	char * pReducedName = new char[s.Length() + 1];
//	char * p = pReducedName;
//	for ( unsigned long i = 0; i < s.Length(); i++)
//		{
//		if ( i < (s.Length() - 1) 
//				&& s[i] == '\\'
//				&& ( s[i+1] == '\\' || s[i+1] == '/') )
//			continue;
//		if ( s[i] == '/')
//			* (p++) = '\\';
//		else
//			* (p++) = s[i];
//		}
//	
//	* p = '\0';
//	s = pReducedName;
//	delete [] pReducedName;
//
//	delete pBuf;
//	

	}

void FileLineManager::SetInclude(const String& aNameText,int aLineNumber)
	{
	iCurrentFileName = ExtractFileName(aNameText);
	iOffsetLineNumber = aLineNumber;	
	}

void FileLineManager::PostInclude( char* aNameText, char * aRealLineNumber, int aLineNumber)
	{	// Returning to a file (after having included another file).
	int val = atoi(aRealLineNumber);
	iCurrentFileName=ExtractFileName(aNameText);
	iOffsetLineNumber=aLineNumber - val + 1;
	}

int	FileLineManager::GetErrorLine(int aCurrentLineNumber) const
	{
	return aCurrentLineNumber-iOffsetLineNumber;
	}

String FileLineManager::GetCurrentFile() const
	{
	return iCurrentFileName;
	}

