// CRTSIS.H
// Copyright (c) 1997-1999 Symbian Ltd. All rights reserved.
//
// Handles creation of a SIS file
//

#ifndef __CRTSIS_H_
#define __CRTSIS_H_

// ===========================================================================
// INCLUDES
// ===========================================================================

#include <instform.h>

#include "parsepkg.h"
#include <stdint.h>


// ===========================================================================
// DEFINES
// ===========================================================================


// ===========================================================================
// CLASS DEFINITIONS
// ===========================================================================


class CSISWriter
// Holds SIS file info, as generated by the parser and builds the output SIS file.
// All strings are held internally by this class as UNICODE (wide) strings.
	{
	public:
		CSISWriter();
		void Release();											// Destroy contained objects and free memory

		void WriteSIS(LPCWSTR pszTargetFile, BOOL fIsStub = FALSE);		// Construct the output SIS file
		
		void AddLanguageNode(LANGNODE *pLNode);
		void AddPkgLineNode(PKGLINENODE *pPkgNode);
		void AddDependencyNode(DEPENDNODE *pNode);
		void AddPlatformDependencyNode(DEPENDNODE *pNode);
		void AddSignatureNode(SIGNATURENODE *pSig);
		void AddCapabilityNode(CAPABILITYNODE *pNode);
		void AddLangStringNode(LANGSTRINGNODE *pLSNode);
		void AddLocalizedVendorNode(LANGSTRINGNODE *pLSNode);
		void AddVendorNode(LANGSTRINGNODE *pLSNode);
		void AddLogo(LOGO *pLSNode);
		void SetSelfsign(BOOL selfsign);

		void SetCmdPassword(LPCWSTR pszCmdPassword);
		void SetObserver(const MParserObserver *pObserver) { m_pObserver = pObserver; }
		void SetVersionInfo(DWORD dwUID, WORD wMajor, WORD wMinor, DWORD dwBuild, TSISType wType, WORD wFlags);
		void SetLangDependFileDestinations(LPCWSTR pszDest, LPCWSTR pszMimeType, DWORD dwType, DWORD dwOptions);
		void SetLangDependCompDestinations(DWORD dwUid);

		BOOL GetCmdPassword(LPWSTR pszCmdPassword) const;
		const MParserObserver* GetObserver()		const { return m_pObserver; };		
		const LANGSTRINGNODE* GetLangStringBase()	const { return m_pLangStringBase; }
		const LANGSTRINGNODE* GetLocalizedVendorBase()	const { return m_pLocalizedVendorBase; }
		const LANGSTRINGNODE* GetVendorName()	const { return m_pVendorName; }
		const LOGO* GetLogoBase()	const { return m_pLogoBase; }
		const LANGNODE* GetLanguageBase()			const { return m_pLangBase; }
		const PKGLINENODE* GetPkgLineBase()			const { return m_pPkgLineBase; }
		const DEPENDNODE* GetDependencyBase()		const { return m_pDependBase; }
		const DEPENDNODE* GetPlatformDependencyBase()		const { return m_pPlatformDependBase; }
		const SIGNATURENODE* GetSignatureBase()		const { return m_pSignatureBase;}
		const CAPABILITYNODE* GetCapabilityBase()	const { return m_pCapabilityBase; }
		DWORD GetUID()								const { return m_dwUID; }
		TSISType GetType()							const { return m_wType; }
		WORD GetFlags()								const { return m_wFlags; }
		WORD GetNoLanguages()						const { return m_wNumLangs; }

		void QueryVersionInfo (WORD* wMajor, WORD* wMinor, DWORD* dwBuild) const;
		BOOL AreLangStringInit();
		BOOL AreLocalizedVendorNamesInit();
		BOOL IsVendorNameInit();

		void SetTimestamp(DWORD dwYear, DWORD dwMonth, DWORD dwDay, DWORD dwHours, DWORD dwMinutes, DWORD dwSeconds);
		BOOL GetTimestamp(DWORD* dwYear, DWORD* dwMonth, DWORD* dwDay, DWORD* dwHours, DWORD* dwMinutes, DWORD* dwSeconds) const;
		BOOL GetSelfsign() const { return m_bSelfsign; }

	private:
		void ReleaseCondExpr(PKGLINECONDITION* expr);				// Destroy condition expr
		
	private:
		// Installation data
		DWORD m_dwUID;						 // Installee app's UID
		WORD m_wMajor;						 // Version info
		WORD m_wMinor;						 //	   "	 "
		DWORD m_dwBuild;					 //	   "	 "
		TSISType m_wType;					 // SIS type (app, system, patch,...)
		WORD m_wFlags;						 // Installation flags (Unicode, redist ++)
		WORD m_wNumLangs;					 // How many languages do we speak ?
		
		LANGSTRINGNODE* m_pLangStringBase;	 // Language strings - the app names in N languages
		LANGSTRINGNODE* m_pLocalizedVendorBase;	 // Localized vendor names
		LANGSTRINGNODE* m_pVendorName;		 // Vendor name
		LOGO* m_pLogoBase;		 // Vendor name
		LANGNODE* m_pLangBase;				 // Language data - which langauges are supported
		PKGLINENODE* m_pPkgLineBase;		 // Linked list of PKG line nodes
		DEPENDNODE* m_pDependBase;			 // Dependency data
		DEPENDNODE* m_pPlatformDependBase;			 // Dependency data
		SIGNATURENODE* m_pSignatureBase;	 // Digital signature data
		CAPABILITYNODE* m_pCapabilityBase;	 // Capability data
		BOOL m_bCmdPassword;				 // Commnand Line Password Flag
		WCHAR m_pszCmdPassword[MAX_PATH];	 // Command Line Decryption Password

		BOOL m_bSetTimestamp;
		DWORD m_dwYear, m_dwMonth, m_dwDay, m_dwHours, m_dwMinutes, m_dwSeconds;
		BOOL m_bSelfsign;
		
		const MParserObserver *m_pObserver;	 // Observer object
	};

#endif // __CRTSIS_H_
